@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property condition Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
 * @property name Name of the branch.
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs(
    public val condition: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchConditionArgs>,
    public val name: Output<String>,
    public val nextStep: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs>,
    public val response: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchResponseArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs.builder()
            .condition(condition.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .nextStep(nextStep.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgsBuilder
internal constructor() {
    private var condition:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchConditionArgs>? =
        null

    private var name: Output<String>? = null

    private var nextStep:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs>? =
        null

    private var response:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchResponseArgs>? =
        null

    /**
     * @param value Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("kxtfogfeulwiammy")
    public suspend fun condition(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("medjsvnudidnfdml")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("ayrflcfijtdyycnc")
    public suspend fun nextStep(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("mhbsqdccrbovuymi")
    public suspend fun response(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("lgrqklgveidocqqr")
    public suspend fun condition(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchConditionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
     */
    @JvmName("dichagixikigmwts")
    public suspend fun condition(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchConditionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("lcoruqdgqlmttmhg")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("lcsqbdnpscpkcmub")
    public suspend fun nextStep(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("axwmlylhlhwbvclr")
    public suspend fun nextStep(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("vpjltnjbykflbajs")
    public suspend fun response(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("vshpglgmtfiqrdvp")
    public suspend fun response(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchArgs(
            condition = condition ?: throw PulumiNullFieldException("condition"),
            name = name ?: throw PulumiNullFieldException("name"),
            nextStep = nextStep ?: throw PulumiNullFieldException("nextStep"),
            response = response,
        )
}
