@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property dialogAction Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
 * @property intent Configuration block for override settings to configure the intent state. See `intent`.
 * @property sessionAttributes Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs(
    public val dialogAction: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepDialogActionArgs>? =
        null,
    public val intent: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepIntentArgs>? =
        null,
    public val sessionAttributes: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs.builder()
            .dialogAction(dialogAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .intent(intent?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sessionAttributes(
                sessionAttributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgsBuilder
internal constructor() {
    private var dialogAction:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepDialogActionArgs>? =
        null

    private var intent:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepIntentArgs>? =
        null

    private var sessionAttributes: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("knuwmrowbvprrvhf")
    public suspend fun dialogAction(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepDialogActionArgs>) {
        this.dialogAction = value
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("udcsqorbghaoavmu")
    public suspend fun intent(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepIntentArgs>) {
        this.intent = value
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("kiucjyknjjebrswm")
    public suspend fun sessionAttributes(`value`: Output<Map<String, String>>) {
        this.sessionAttributes = value
    }

    /**
     * @param value Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("gxvugaeqfrywtsad")
    public suspend fun dialogAction(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepDialogActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialogAction = mapped
    }

    /**
     * @param argument Configuration block for action that the bot executes at runtime when the conversation reaches this step. See `dialog_action`.
     */
    @JvmName("qebwxcsfxomahrho")
    public suspend fun dialogAction(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepDialogActionArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepDialogActionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dialogAction = mapped
    }

    /**
     * @param value Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("obhkhdfbttiectdx")
    public suspend fun intent(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepIntentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intent = mapped
    }

    /**
     * @param argument Configuration block for override settings to configure the intent state. See `intent`.
     */
    @JvmName("iqiliyiwdhwkjcon")
    public suspend fun intent(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepIntentArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepIntentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.intent = mapped
    }

    /**
     * @param value Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("eikrjoywkivlcgkm")
    public suspend fun sessionAttributes(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    /**
     * @param values Map of key/value pairs representing session-specific context information. It contains application information passed between Amazon Lex and a client application.
     */
    @JvmName("axgsuvnperoclblp")
    public fun sessionAttributes(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionAttributes = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessConditionalConditionalBranchNextStepArgs(
            dialogAction = dialogAction,
            intent = intent,
            sessionAttributes = sessionAttributes,
        )
}
