@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property text Text that appears on the button. Use this to tell the user what value is returned when they choose this button.
 * @property value Value returned to Amazon Lex when the user chooses this button. This must be one of the slot values configured for the slot.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs(
    public val text: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs.builder()
            .text(text.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgsBuilder
internal constructor() {
    private var text: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Text that appears on the button. Use this to tell the user what value is returned when they choose this button.
     */
    @JvmName("jfeycioajwfxpikc")
    public suspend fun text(`value`: Output<String>) {
        this.text = value
    }

    /**
     * @param value Value returned to Amazon Lex when the user chooses this button. This must be one of the slot values configured for the slot.
     */
    @JvmName("yfwqowemxvbsbqxe")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Text that appears on the button. Use this to tell the user what value is returned when they choose this button.
     */
    @JvmName("cywmulbudktvshuo")
    public suspend fun text(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.text = mapped
    }

    /**
     * @param value Value returned to Amazon Lex when the user chooses this button. This must be one of the slot values configured for the slot.
     */
    @JvmName("gnhyusibokifqqeo")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationSuccessResponseMessageGroupMessageImageResponseCardButtonArgs(
            text = text ?: throw PulumiNullFieldException("text"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
