@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property buttons Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
 * @property imageUrl URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
 * @property subtitle Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
 * @property title Title to display on the response card. The format of the title is determined by the platform displaying the response card.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs(
    public val buttons: Output<List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs>>? =
        null,
    public val imageUrl: Output<String>? = null,
    public val subtitle: Output<String>? = null,
    public val title: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs.builder()
            .buttons(
                buttons?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .imageUrl(imageUrl?.applyValue({ args0 -> args0 }))
            .subtitle(subtitle?.applyValue({ args0 -> args0 }))
            .title(title.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgsBuilder
internal constructor() {
    private var buttons:
        Output<List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs>>? =
        null

    private var imageUrl: Output<String>? = null

    private var subtitle: Output<String>? = null

    private var title: Output<String>? = null

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("mmilwdvnynexfxdm")
    public suspend fun buttons(`value`: Output<List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs>>) {
        this.buttons = value
    }

    @JvmName("denycfkhxjyuvlid")
    public suspend fun buttons(vararg values: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs>) {
        this.buttons = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("ywvbvlqhfpathjmo")
    public suspend fun buttons(values: List<Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs>>) {
        this.buttons = Output.all(values)
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("csotxhfeqqalfdoh")
    public suspend fun imageUrl(`value`: Output<String>) {
        this.imageUrl = value
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("sjhrvfwyjawoyekp")
    public suspend fun subtitle(`value`: Output<String>) {
        this.subtitle = value
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("achaedpbdtxhabwc")
    public suspend fun title(`value`: Output<String>) {
        this.title = value
    }

    /**
     * @param value Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("qooovrvmbcjeblgi")
    public suspend fun buttons(`value`: List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("csnqyiwyfkfrkett")
    public suspend fun buttons(argument: List<suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("qwwmdpcliwxqoaks")
    public suspend fun buttons(vararg argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param argument Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("nlbmxjujqhndfwsg")
    public suspend fun buttons(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.buttons = mapped
    }

    /**
     * @param values Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
     */
    @JvmName("slqfibsfdnqcphuj")
    public suspend fun buttons(vararg values: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardButtonArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buttons = mapped
    }

    /**
     * @param value URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
     */
    @JvmName("flxgkrlcrbqkyjyo")
    public suspend fun imageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageUrl = mapped
    }

    /**
     * @param value Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
     */
    @JvmName("mqunhaaqgbqqwfwg")
    public suspend fun subtitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subtitle = mapped
    }

    /**
     * @param value Title to display on the response card. The format of the title is determined by the platform displaying the response card.
     */
    @JvmName("ldfbnuepsoqtyshy")
    public suspend fun title(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.title = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutConditionalDefaultBranchResponseMessageGroupVariationImageResponseCardArgs(
            buttons = buttons,
            imageUrl = imageUrl,
            subtitle = subtitle,
            title = title ?: throw PulumiNullFieldException("title"),
        )
}
