@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property message Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
 * @property variations Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
 */
public data class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs(
    public val message: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupMessageArgs>,
    public val variations: Output<List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs.builder()
            .message(message.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgsBuilder
internal constructor() {
    private var message:
        Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupMessageArgs>? =
        null

    private var variations:
        Output<List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs>>? =
        null

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("gkmpjhvjwflferkt")
    public suspend fun message(`value`: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupMessageArgs>) {
        this.message = value
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("bwtovleockhoyfoo")
    public suspend fun variations(`value`: Output<List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs>>) {
        this.variations = value
    }

    @JvmName("jcsrgcspparkxbnk")
    public suspend fun variations(vararg values: Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("yixjpwoiinknrfqa")
    public suspend fun variations(values: List<Output<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("yxggluelucdewhgi")
    public suspend fun message(`value`: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupMessageArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param argument Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("egxqyuoggsqtoikk")
    public suspend fun message(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.message = mapped
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("cbsvuinmbjfafhkg")
    public suspend fun variations(`value`: List<V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("uyiaotclhcprtggt")
    public suspend fun variations(argument: List<suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("aqrvthcdgpacinim")
    public suspend fun variations(vararg argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("veirakmheywywvon")
    public suspend fun variations(argument: suspend V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("fbioughyqrohubwp")
    public suspend fun variations(vararg values: V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs =
        V2modelsIntentInitialResponseSettingCodeHookPostCodeHookSpecificationTimeoutResponseMessageGroupArgs(
            message = message ?: throw PulumiNullFieldException("message"),
            variations = variations,
        )
}
