@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the intent.
 * @property slots Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
 */
public data class
V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs(
    public val name: Output<String>? = null,
    public val slots: Output<List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .slots(
                slots?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgsBuilder
internal constructor() {
    private var name: Output<String>? = null

    private var slots:
        Output<List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs>>? =
        null

    /**
     * @param value Name of the intent.
     */
    @JvmName("tddumyjwxsvuskxx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("canfjfkqnscgudai")
    public suspend fun slots(`value`: Output<List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs>>) {
        this.slots = value
    }

    @JvmName("gkedkalqkrkdmoap")
    public suspend fun slots(vararg values: Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs>) {
        this.slots = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("oyafjckmipokgijs")
    public suspend fun slots(values: List<Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs>>) {
        this.slots = Output.all(values)
    }

    /**
     * @param value Name of the intent.
     */
    @JvmName("urwfxibhqfuufkmk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("rlhxqdwuutlkpuyw")
    public suspend fun slots(`value`: List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("gstaepleqtjghoqh")
    public suspend fun slots(argument: List<suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("dyvehgtmcyemauxk")
    public suspend fun slots(vararg argument: suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param argument Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("ojyjpuoapedpcmkk")
    public suspend fun slots(argument: suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.slots = mapped
    }

    /**
     * @param values Configuration block for all of the slot value overrides for the intent. The name of the slot maps to the value of the slot. Slots that are not included in the map aren't overridden. See `slot`.
     */
    @JvmName("dtcxkukuumcrpagn")
    public suspend fun slots(vararg values: V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentSlotArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slots = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs =
        V2modelsIntentInitialResponseSettingConditionalConditionalBranchNextStepIntentArgs(
            name = name,
            slots = slots,
        )
}
