@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property message Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
 * @property variations Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
 */
public data class
V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs(
    public val message: Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupMessageArgs>,
    public val variations: Output<List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs.builder()
            .message(message.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgsBuilder
internal constructor() {
    private var message:
        Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupMessageArgs>? =
        null

    private var variations:
        Output<List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>? =
        null

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("rljgabxpvpvychhs")
    public suspend fun message(`value`: Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupMessageArgs>) {
        this.message = value
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("ltmxcindgqxnvmef")
    public suspend fun variations(`value`: Output<List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>) {
        this.variations = value
    }

    @JvmName("vgquxmvdffxrootu")
    public suspend fun variations(vararg values: Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("knoyhrvdsnududxn")
    public suspend fun variations(values: List<Output<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("jcxpkpmsnqlgwlyy")
    public suspend fun message(`value`: V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupMessageArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param argument Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("ruhcyptkdkghdgeg")
    public suspend fun message(argument: suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.message = mapped
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("wandvynqekeydblt")
    public suspend fun variations(`value`: List<V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("rcemdaeqeabfxmtv")
    public suspend fun variations(argument: List<suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("bictesyvdrhlykdl")
    public suspend fun variations(vararg argument: suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("xxcpwmnmycmnbdev")
    public suspend fun variations(argument: suspend V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("slspmtvtavelsfcn")
    public suspend fun variations(vararg values: V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs =
        V2modelsIntentInitialResponseSettingConditionalConditionalBranchResponseMessageGroupArgs(
            message = message ?: throw PulumiNullFieldException("message"),
            variations = variations,
        )
}
