@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs(
    public val nextStep: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchNextStepArgs>? = null,
    public val response: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs.builder()
            .nextStep(nextStep?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgsBuilder internal constructor() {
    private var nextStep:
        Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchNextStepArgs>? = null

    private var response:
        Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs>? = null

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("gebdtkwlklwewilm")
    public suspend fun nextStep(`value`: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchNextStepArgs>) {
        this.nextStep = value
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("qubttujeqrvboqup")
    public suspend fun response(`value`: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs>) {
        this.response = value
    }

    /**
     * @param value Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("bemuiiaeleboauqg")
    public suspend fun nextStep(`value`: V2modelsIntentInitialResponseSettingConditionalDefaultBranchNextStepArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextStep = mapped
    }

    /**
     * @param argument Configuration block for the next step in the conversation. See `next_step`.
     */
    @JvmName("bxojedfbwfrlhybb")
    public suspend fun nextStep(argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchNextStepArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchNextStepArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.nextStep = mapped
    }

    /**
     * @param value Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("laffjamfodjknana")
    public suspend fun response(`value`: V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
     */
    @JvmName("foiybykrmgnqqikq")
    public suspend fun response(argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs =
        V2modelsIntentInitialResponseSettingConditionalDefaultBranchArgs(
            nextStep = nextStep,
            response = response,
        )
}
