@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech response from Amazon Lex.
 * @property messageGroups Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
 */
public data class V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs(
    public val allowInterrupt: Output<Boolean>? = null,
    public val messageGroups: Output<List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs.builder()
            .allowInterrupt(allowInterrupt?.applyValue({ args0 -> args0 }))
            .messageGroups(
                messageGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgsBuilder
internal constructor() {
    private var allowInterrupt: Output<Boolean>? = null

    private var messageGroups:
        Output<List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs>>? =
        null

    /**
     * @param value Whether the user can interrupt a speech response from Amazon Lex.
     */
    @JvmName("hrylpuijjieaovrc")
    public suspend fun allowInterrupt(`value`: Output<Boolean>) {
        this.allowInterrupt = value
    }

    /**
     * @param value Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("vbmoicpbqterwnrl")
    public suspend fun messageGroups(`value`: Output<List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs>>) {
        this.messageGroups = value
    }

    @JvmName("jrqxxpedbynoawpr")
    public suspend fun messageGroups(vararg values: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs>) {
        this.messageGroups = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("pbwubschnaptggal")
    public suspend fun messageGroups(values: List<Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs>>) {
        this.messageGroups = Output.all(values)
    }

    /**
     * @param value Whether the user can interrupt a speech response from Amazon Lex.
     */
    @JvmName("mshnmwutboemlyyt")
    public suspend fun allowInterrupt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInterrupt = mapped
    }

    /**
     * @param value Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("mcyqrxyaakmqhvya")
    public suspend fun messageGroups(`value`: List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("oatdideemjmwxyak")
    public suspend fun messageGroups(argument: List<suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("uhssityplfbhrvyn")
    public suspend fun messageGroups(vararg argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("uysdkxxarweaxaqt")
    public suspend fun messageGroups(argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param values Configuration blocks for responses that Amazon Lex can send to the user. Amazon Lex chooses the actual response to send at runtime. See `message_group`.
     */
    @JvmName("kodvbhxpchvtnsny")
    public suspend fun messageGroups(vararg values: V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs =
        V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseArgs(
            allowInterrupt = allowInterrupt,
            messageGroups = messageGroups,
        )
}
