@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property message Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
 * @property variations Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
 */
public data class
V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs(
    public val message: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupMessageArgs>,
    public val variations: Output<List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs.builder()
            .message(message.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variations(
                variations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs].
 */
@PulumiTagMarker
public class
V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgsBuilder
internal constructor() {
    private var message:
        Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupMessageArgs>? =
        null

    private var variations:
        Output<List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs>>? =
        null

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("tfbwylpnpryxgdlr")
    public suspend fun message(`value`: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupMessageArgs>) {
        this.message = value
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("nmqcbapbcwerwniq")
    public suspend fun variations(`value`: Output<List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs>>) {
        this.variations = value
    }

    @JvmName("dmhggbjotjeyomnd")
    public suspend fun variations(vararg values: Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs>) {
        this.variations = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("rprrstdfkcydjjwu")
    public suspend fun variations(values: List<Output<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs>>) {
        this.variations = Output.all(values)
    }

    /**
     * @param value Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("fcqtmkaprioliwka")
    public suspend fun message(`value`: V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupMessageArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param argument Configuration block for the primary message that Amazon Lex should send to the user. See `message`.
     */
    @JvmName("vxvvgegydjhmyosb")
    public suspend fun message(argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.message = mapped
    }

    /**
     * @param value Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("uajhatdwfiedhrgq")
    public suspend fun variations(`value`: List<V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("ighwqbvwgqpvxlsh")
    public suspend fun variations(argument: List<suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("odgsrufomfckrifv")
    public suspend fun variations(vararg argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param argument Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("fnosvqgnrfkvjnbq")
    public suspend fun variations(argument: suspend V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.variations = mapped
    }

    /**
     * @param values Configuration blocks for message variations to send to the user. When variations are defined, Amazon Lex chooses the primary message or one of the variations to send to the user. See `variation`.
     */
    @JvmName("gpompyrkpchasmju")
    public suspend fun variations(vararg values: V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupVariationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.variations = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs =
        V2modelsIntentInitialResponseSettingConditionalDefaultBranchResponseMessageGroupArgs(
            message = message ?: throw PulumiNullFieldException("message"),
            variations = variations,
        )
}
