@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs(
    public val customPayload: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationCustomPayloadArgs>? =
        null,
    public val imageResponseCard: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationImageResponseCardArgs>? =
        null,
    public val plainTextMessage: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationPlainTextMessageArgs>? =
        null,
    public val ssmlMessage: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationSsmlMessageArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs.builder()
            .customPayload(customPayload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageResponseCard(imageResponseCard?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .plainTextMessage(plainTextMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ssmlMessage(ssmlMessage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgsBuilder
internal constructor() {
    private var customPayload:
        Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationCustomPayloadArgs>? =
        null

    private var imageResponseCard:
        Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationImageResponseCardArgs>? =
        null

    private var plainTextMessage:
        Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationPlainTextMessageArgs>? =
        null

    private var ssmlMessage:
        Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationSsmlMessageArgs>? =
        null

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("xdxyyilelhqykaiy")
    public suspend fun customPayload(`value`: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationCustomPayloadArgs>) {
        this.customPayload = value
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("gldawvmjqkvccvut")
    public suspend fun imageResponseCard(`value`: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationImageResponseCardArgs>) {
        this.imageResponseCard = value
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("eoikavuynrkaudmc")
    public suspend fun plainTextMessage(`value`: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationPlainTextMessageArgs>) {
        this.plainTextMessage = value
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("aydukmeiqxarnmyw")
    public suspend fun ssmlMessage(`value`: Output<V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationSsmlMessageArgs>) {
        this.ssmlMessage = value
    }

    /**
     * @param value Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("furjbopwvfolfswl")
    public suspend fun customPayload(`value`: V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationCustomPayloadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customPayload = mapped
    }

    /**
     * @param argument Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
     */
    @JvmName("tjcohhdaxirjaexl")
    public suspend fun customPayload(argument: suspend V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationCustomPayloadArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationCustomPayloadArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customPayload = mapped
    }

    /**
     * @param value Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("gerswwarjqnhydyj")
    public suspend fun imageResponseCard(`value`: V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationImageResponseCardArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageResponseCard = mapped
    }

    /**
     * @param argument Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
     */
    @JvmName("dfvytnmfdsfgpnpw")
    public suspend fun imageResponseCard(argument: suspend V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationImageResponseCardArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationImageResponseCardArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.imageResponseCard = mapped
    }

    /**
     * @param value Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("annbxdvcwlogxxrr")
    public suspend fun plainTextMessage(`value`: V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationPlainTextMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plainTextMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in plain text format. See `plain_text_message`.
     */
    @JvmName("krywtfbqjorrdnex")
    public suspend fun plainTextMessage(argument: suspend V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationPlainTextMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationPlainTextMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.plainTextMessage = mapped
    }

    /**
     * @param value Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("xlywmjktfrucklxq")
    public suspend fun ssmlMessage(`value`: V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationSsmlMessageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssmlMessage = mapped
    }

    /**
     * @param argument Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
     */
    @JvmName("tjpefclvahlrfgeq")
    public suspend fun ssmlMessage(argument: suspend V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationSsmlMessageArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationSsmlMessageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ssmlMessage = mapped
    }

    internal fun build(): V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs = V2modelsIntentInitialResponseSettingInitialResponseMessageGroupVariationArgs(
        customPayload = customPayload,
        imageResponseCard = imageResponseCard,
        plainTextMessage = plainTextMessage,
        ssmlMessage = ssmlMessage,
    )
}
