@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentInputContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the context.
 */
public data class V2modelsIntentInputContextArgs(
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentInputContextArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentInputContextArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentInputContextArgs.builder()
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentInputContextArgs].
 */
@PulumiTagMarker
public class V2modelsIntentInputContextArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the context.
     */
    @JvmName("rbysenpwlekqeiic")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the context.
     */
    @JvmName("fvyoythjiobbycrl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): V2modelsIntentInputContextArgs = V2modelsIntentInputContextArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
