@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentKendraConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kendraIndex ARN of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot.
 * @property queryFilterString Query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see [Filtering queries](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
 * @property queryFilterStringEnabled Whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
 */
public data class V2modelsIntentKendraConfigurationArgs(
    public val kendraIndex: Output<String>,
    public val queryFilterString: Output<String>? = null,
    public val queryFilterStringEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentKendraConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentKendraConfigurationArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentKendraConfigurationArgs.builder()
            .kendraIndex(kendraIndex.applyValue({ args0 -> args0 }))
            .queryFilterString(queryFilterString?.applyValue({ args0 -> args0 }))
            .queryFilterStringEnabled(queryFilterStringEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentKendraConfigurationArgs].
 */
@PulumiTagMarker
public class V2modelsIntentKendraConfigurationArgsBuilder internal constructor() {
    private var kendraIndex: Output<String>? = null

    private var queryFilterString: Output<String>? = null

    private var queryFilterStringEnabled: Output<Boolean>? = null

    /**
     * @param value ARN of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot.
     */
    @JvmName("ekhfdsotwbhqevjf")
    public suspend fun kendraIndex(`value`: Output<String>) {
        this.kendraIndex = value
    }

    /**
     * @param value Query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see [Filtering queries](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
     */
    @JvmName("bkxwdxqfsidsttei")
    public suspend fun queryFilterString(`value`: Output<String>) {
        this.queryFilterString = value
    }

    /**
     * @param value Whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
     */
    @JvmName("lbguuteooyibhjja")
    public suspend fun queryFilterStringEnabled(`value`: Output<Boolean>) {
        this.queryFilterStringEnabled = value
    }

    /**
     * @param value ARN of the Amazon Kendra index that you want the AMAZON.KendraSearchIntent intent to search. The index must be in the same account and Region as the Amazon Lex bot.
     */
    @JvmName("krfaaicpbgpykovu")
    public suspend fun kendraIndex(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kendraIndex = mapped
    }

    /**
     * @param value Query filter that Amazon Lex sends to Amazon Kendra to filter the response from a query. The filter is in the format defined by Amazon Kendra. For more information, see [Filtering queries](https://docs.aws.amazon.com/kendra/latest/dg/filtering.html).
     */
    @JvmName("lipfwfyxpsttukjm")
    public suspend fun queryFilterString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryFilterString = mapped
    }

    /**
     * @param value Whether the AMAZON.KendraSearchIntent intent uses a custom query string to query the Amazon Kendra index.
     */
    @JvmName("hhuuqcnctgoaetyk")
    public suspend fun queryFilterStringEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryFilterStringEnabled = mapped
    }

    internal fun build(): V2modelsIntentKendraConfigurationArgs =
        V2modelsIntentKendraConfigurationArgs(
            kendraIndex = kendraIndex ?: throw PulumiNullFieldException("kendraIndex"),
            queryFilterString = queryFilterString,
            queryFilterStringEnabled = queryFilterStringEnabled,
        )
}
