@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentOutputContextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the output context.
 * @property timeToLiveInSeconds Amount of time, in seconds, that the output context should remain active. The time is figured from the first time the context is sent to the user.
 * @property turnsToLive Number of conversation turns that the output context should remain active. The number of turns is counted from the first time that the context is sent to the user.
 */
public data class V2modelsIntentOutputContextArgs(
    public val name: Output<String>,
    public val timeToLiveInSeconds: Output<Int>,
    public val turnsToLive: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentOutputContextArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentOutputContextArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentOutputContextArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .timeToLiveInSeconds(timeToLiveInSeconds.applyValue({ args0 -> args0 }))
            .turnsToLive(turnsToLive.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentOutputContextArgs].
 */
@PulumiTagMarker
public class V2modelsIntentOutputContextArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var timeToLiveInSeconds: Output<Int>? = null

    private var turnsToLive: Output<Int>? = null

    /**
     * @param value Name of the output context.
     */
    @JvmName("gprjxowjolthiory")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Amount of time, in seconds, that the output context should remain active. The time is figured from the first time the context is sent to the user.
     */
    @JvmName("axtoikdqvyefkmup")
    public suspend fun timeToLiveInSeconds(`value`: Output<Int>) {
        this.timeToLiveInSeconds = value
    }

    /**
     * @param value Number of conversation turns that the output context should remain active. The number of turns is counted from the first time that the context is sent to the user.
     */
    @JvmName("kqqwisbccrooegwu")
    public suspend fun turnsToLive(`value`: Output<Int>) {
        this.turnsToLive = value
    }

    /**
     * @param value Name of the output context.
     */
    @JvmName("fxsyatppgdwnsagx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Amount of time, in seconds, that the output context should remain active. The time is figured from the first time the context is sent to the user.
     */
    @JvmName("bvqkcpwqyyslpval")
    public suspend fun timeToLiveInSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timeToLiveInSeconds = mapped
    }

    /**
     * @param value Number of conversation turns that the output context should remain active. The number of turns is counted from the first time that the context is sent to the user.
     */
    @JvmName("jlrcjmniiclnrmno")
    public suspend fun turnsToLive(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.turnsToLive = mapped
    }

    internal fun build(): V2modelsIntentOutputContextArgs = V2modelsIntentOutputContextArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        timeToLiveInSeconds = timeToLiveInSeconds ?: throw PulumiNullFieldException("timeToLiveInSeconds"),
        turnsToLive = turnsToLive ?: throw PulumiNullFieldException("turnsToLive"),
    )
}
