@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentSampleUtteranceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property utterance Sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
 */
public data class V2modelsIntentSampleUtteranceArgs(
    public val utterance: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentSampleUtteranceArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentSampleUtteranceArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentSampleUtteranceArgs.builder()
            .utterance(utterance.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentSampleUtteranceArgs].
 */
@PulumiTagMarker
public class V2modelsIntentSampleUtteranceArgsBuilder internal constructor() {
    private var utterance: Output<String>? = null

    /**
     * @param value Sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
     */
    @JvmName("vtbquqqwcevagbsm")
    public suspend fun utterance(`value`: Output<String>) {
        this.utterance = value
    }

    /**
     * @param value Sample utterance that Amazon Lex uses to build its machine-learning model to recognize intents.
     */
    @JvmName("egivdajvjpiifjva")
    public suspend fun utterance(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.utterance = mapped
    }

    internal fun build(): V2modelsIntentSampleUtteranceArgs = V2modelsIntentSampleUtteranceArgs(
        utterance = utterance ?: throw PulumiNullFieldException("utterance"),
    )
}
