@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsIntentSlotPriorityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property priority Priority that Amazon Lex should apply to the slot.
 * @property slotId Unique identifier of the slot.
 */
public data class V2modelsIntentSlotPriorityArgs(
    public val priority: Output<Int>,
    public val slotId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsIntentSlotPriorityArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsIntentSlotPriorityArgs =
        com.pulumi.aws.lex.inputs.V2modelsIntentSlotPriorityArgs.builder()
            .priority(priority.applyValue({ args0 -> args0 }))
            .slotId(slotId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsIntentSlotPriorityArgs].
 */
@PulumiTagMarker
public class V2modelsIntentSlotPriorityArgsBuilder internal constructor() {
    private var priority: Output<Int>? = null

    private var slotId: Output<String>? = null

    /**
     * @param value Priority that Amazon Lex should apply to the slot.
     */
    @JvmName("mqojxpesitqhpcbn")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Unique identifier of the slot.
     */
    @JvmName("ajrqofrntjdbopby")
    public suspend fun slotId(`value`: Output<String>) {
        this.slotId = value
    }

    /**
     * @param value Priority that Amazon Lex should apply to the slot.
     */
    @JvmName("mkfckvymnnbkqhcq")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Unique identifier of the slot.
     */
    @JvmName("mmitoweyrejjejdw")
    public suspend fun slotId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotId = mapped
    }

    internal fun build(): V2modelsIntentSlotPriorityArgs = V2modelsIntentSlotPriorityArgs(
        priority = priority ?: throw PulumiNullFieldException("priority"),
        slotId = slotId ?: throw PulumiNullFieldException("slotId"),
    )
}
