@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotMultipleValuesSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property allowMultipleValues Whether a slot can return multiple values. When `true`, the slot may return more than one value in a response. When `false`, the slot returns only a single value. Multi-value slots are only available in the `en-US` locale.
 */
public data class V2modelsSlotMultipleValuesSettingArgs(
    public val allowMultipleValues: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotMultipleValuesSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotMultipleValuesSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotMultipleValuesSettingArgs.builder()
            .allowMultipleValues(allowMultipleValues?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsSlotMultipleValuesSettingArgs].
 */
@PulumiTagMarker
public class V2modelsSlotMultipleValuesSettingArgsBuilder internal constructor() {
    private var allowMultipleValues: Output<Boolean>? = null

    /**
     * @param value Whether a slot can return multiple values. When `true`, the slot may return more than one value in a response. When `false`, the slot returns only a single value. Multi-value slots are only available in the `en-US` locale.
     */
    @JvmName("cacvaujuufoyxeph")
    public suspend fun allowMultipleValues(`value`: Output<Boolean>) {
        this.allowMultipleValues = value
    }

    /**
     * @param value Whether a slot can return multiple values. When `true`, the slot may return more than one value in a response. When `false`, the slot returns only a single value. Multi-value slots are only available in the `en-US` locale.
     */
    @JvmName("qpfnpkknthjxhvku")
    public suspend fun allowMultipleValues(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowMultipleValues = mapped
    }

    internal fun build(): V2modelsSlotMultipleValuesSettingArgs =
        V2modelsSlotMultipleValuesSettingArgs(
            allowMultipleValues = allowMultipleValues,
        )
}
