@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotObfuscationSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property obfuscationSettingType Whether Amazon Lex obscures slot values in conversation logs. Valid values are `DefaultObfuscation` and `None`.
 */
public data class V2modelsSlotObfuscationSettingArgs(
    public val obfuscationSettingType: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotObfuscationSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotObfuscationSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotObfuscationSettingArgs.builder()
            .obfuscationSettingType(obfuscationSettingType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsSlotObfuscationSettingArgs].
 */
@PulumiTagMarker
public class V2modelsSlotObfuscationSettingArgsBuilder internal constructor() {
    private var obfuscationSettingType: Output<String>? = null

    /**
     * @param value Whether Amazon Lex obscures slot values in conversation logs. Valid values are `DefaultObfuscation` and `None`.
     */
    @JvmName("jylvalraonmetfdo")
    public suspend fun obfuscationSettingType(`value`: Output<String>) {
        this.obfuscationSettingType = value
    }

    /**
     * @param value Whether Amazon Lex obscures slot values in conversation logs. Valid values are `DefaultObfuscation` and `None`.
     */
    @JvmName("kchxysxgyvndydtb")
    public suspend fun obfuscationSettingType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.obfuscationSettingType = mapped
    }

    internal fun build(): V2modelsSlotObfuscationSettingArgs = V2modelsSlotObfuscationSettingArgs(
        obfuscationSettingType = obfuscationSettingType ?: throw
            PulumiNullFieldException("obfuscationSettingType"),
    )
}
