@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property expression
 * @property slotSpecifications
 */
public data class V2modelsSlotSubSlotSettingArgs(
    public val expression: Output<String>? = null,
    public val slotSpecifications: Output<List<V2modelsSlotSubSlotSettingSlotSpecificationArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .slotSpecifications(
                slotSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotSubSlotSettingArgs].
 */
@PulumiTagMarker
public class V2modelsSlotSubSlotSettingArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var slotSpecifications: Output<List<V2modelsSlotSubSlotSettingSlotSpecificationArgs>>? =
        null

    /**
     * @param value
     */
    @JvmName("mirqwfdtcccncfyj")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value
     */
    @JvmName("rqauqgvjixsnecum")
    public suspend fun slotSpecifications(`value`: Output<List<V2modelsSlotSubSlotSettingSlotSpecificationArgs>>) {
        this.slotSpecifications = value
    }

    @JvmName("tvcxgphxsryrlons")
    public suspend fun slotSpecifications(vararg values: Output<V2modelsSlotSubSlotSettingSlotSpecificationArgs>) {
        this.slotSpecifications = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rdnhymchrdlnloav")
    public suspend fun slotSpecifications(values: List<Output<V2modelsSlotSubSlotSettingSlotSpecificationArgs>>) {
        this.slotSpecifications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("jtqlqwkjskyidens")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value
     */
    @JvmName("tqclgnaiatmyunjd")
    public suspend fun slotSpecifications(`value`: List<V2modelsSlotSubSlotSettingSlotSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("karvajwvelyvuxik")
    public suspend fun slotSpecifications(argument: List<suspend V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.slotSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fyrrhoawxidwhqes")
    public suspend fun slotSpecifications(vararg argument: suspend V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.slotSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ptjfcdrctlmhbgqw")
    public suspend fun slotSpecifications(argument: suspend V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.slotSpecifications = mapped
    }

    /**
     * @param values
     */
    @JvmName("qkdwaucapsxiarfv")
    public suspend fun slotSpecifications(vararg values: V2modelsSlotSubSlotSettingSlotSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotSpecifications = mapped
    }

    internal fun build(): V2modelsSlotSubSlotSettingArgs = V2modelsSlotSubSlotSettingArgs(
        expression = expression,
        slotSpecifications = slotSpecifications,
    )
}
