@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingSlotSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property mapBlockKey
 * @property slotTypeId Unique identifier for the slot type associated with this slot.
 * @property valueElicitationSettings Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
 * The following arguments are optional:
 */
public data class V2modelsSlotSubSlotSettingSlotSpecificationArgs(
    public val mapBlockKey: Output<String>,
    public val slotTypeId: Output<String>,
    public val valueElicitationSettings: Output<List<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingSlotSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingSlotSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotSubSlotSettingSlotSpecificationArgs.builder()
            .mapBlockKey(mapBlockKey.applyValue({ args0 -> args0 }))
            .slotTypeId(slotTypeId.applyValue({ args0 -> args0 }))
            .valueElicitationSettings(
                valueElicitationSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotSubSlotSettingSlotSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsSlotSubSlotSettingSlotSpecificationArgsBuilder internal constructor() {
    private var mapBlockKey: Output<String>? = null

    private var slotTypeId: Output<String>? = null

    private var valueElicitationSettings:
        Output<List<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs>>? = null

    /**
     * @param value
     */
    @JvmName("jdnryovftxubcwsd")
    public suspend fun mapBlockKey(`value`: Output<String>) {
        this.mapBlockKey = value
    }

    /**
     * @param value Unique identifier for the slot type associated with this slot.
     */
    @JvmName("bjcfncskgewjohjm")
    public suspend fun slotTypeId(`value`: Output<String>) {
        this.slotTypeId = value
    }

    /**
     * @param value Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("guufotwgfsrllixr")
    public suspend fun valueElicitationSettings(`value`: Output<List<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs>>) {
        this.valueElicitationSettings = value
    }

    @JvmName("lmgurjbpflkfrals")
    public suspend fun valueElicitationSettings(vararg values: Output<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs>) {
        this.valueElicitationSettings = Output.all(values.asList())
    }

    /**
     * @param values Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("prsjvmgssjwxblnp")
    public suspend fun valueElicitationSettings(values: List<Output<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs>>) {
        this.valueElicitationSettings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gclvmmatdcautsut")
    public suspend fun mapBlockKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mapBlockKey = mapped
    }

    /**
     * @param value Unique identifier for the slot type associated with this slot.
     */
    @JvmName("mghydxvfkkiaewrs")
    public suspend fun slotTypeId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotTypeId = mapped
    }

    /**
     * @param value Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("rgonfcsijshtcgii")
    public suspend fun valueElicitationSettings(`value`: List<V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.valueElicitationSettings = mapped
    }

    /**
     * @param argument Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("cecsrqoedvyyibpk")
    public suspend fun valueElicitationSettings(argument: List<suspend V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.valueElicitationSettings = mapped
    }

    /**
     * @param argument Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("lbapnasmumggkffq")
    public suspend fun valueElicitationSettings(vararg argument: suspend V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.valueElicitationSettings = mapped
    }

    /**
     * @param argument Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("iocyuawhlqplgadn")
    public suspend fun valueElicitationSettings(argument: suspend V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.valueElicitationSettings = mapped
    }

    /**
     * @param values Prompts that Amazon Lex sends to the user to elicit a response that provides the value for the slot.
     * The following arguments are optional:
     */
    @JvmName("tedeeprjkghscnhc")
    public suspend fun valueElicitationSettings(vararg values: V2modelsSlotSubSlotSettingSlotSpecificationValueElicitationSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueElicitationSettings = mapped
    }

    internal fun build(): V2modelsSlotSubSlotSettingSlotSpecificationArgs =
        V2modelsSlotSubSlotSettingSlotSpecificationArgs(
            mapBlockKey = mapBlockKey ?: throw PulumiNullFieldException("mapBlockKey"),
            slotTypeId = slotTypeId ?: throw PulumiNullFieldException("slotTypeId"),
            valueElicitationSettings = valueElicitationSettings,
        )
}
