@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the slot type
 * The following arguments are optional:
 * @property subSlotId
 */
public data class V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs(
    public val name: Output<String>,
    public val subSlotId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .subSlotId(subSlotId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var subSlotId: Output<String>? = null

    /**
     * @param value Name of the slot type
     * The following arguments are optional:
     */
    @JvmName("kflrgkoiliajhert")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("gcyfgfpsqxadmfji")
    public suspend fun subSlotId(`value`: Output<String>) {
        this.subSlotId = value
    }

    /**
     * @param value Name of the slot type
     * The following arguments are optional:
     */
    @JvmName("titfqaaqkdtcfbcr")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("hkyonyfjkwykuvhf")
    public suspend fun subSlotId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subSlotId = mapped
    }

    internal fun build(): V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs =
        V2modelsSlotTypeCompositeSlotTypeSettingSubSlotArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            subSlotId = subSlotId ?: throw PulumiNullFieldException("subSlotId"),
        )
}
