@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property grammarSlotTypeSetting Settings required for a slot type based on a grammar that you provide. See `grammar_slot_type_setting` argument reference below.
 */
public data class V2modelsSlotTypeExternalSourceSettingArgs(
    public val grammarSlotTypeSetting: Output<V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingArgs.builder()
            .grammarSlotTypeSetting(
                grammarSlotTypeSetting?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotTypeExternalSourceSettingArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeExternalSourceSettingArgsBuilder internal constructor() {
    private var grammarSlotTypeSetting:
        Output<V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingArgs>? = null

    /**
     * @param value Settings required for a slot type based on a grammar that you provide. See `grammar_slot_type_setting` argument reference below.
     */
    @JvmName("ekyyuakypxwbalid")
    public suspend fun grammarSlotTypeSetting(`value`: Output<V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingArgs>) {
        this.grammarSlotTypeSetting = value
    }

    /**
     * @param value Settings required for a slot type based on a grammar that you provide. See `grammar_slot_type_setting` argument reference below.
     */
    @JvmName("ufnwehcxqjlburyh")
    public suspend fun grammarSlotTypeSetting(`value`: V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grammarSlotTypeSetting = mapped
    }

    /**
     * @param argument Settings required for a slot type based on a grammar that you provide. See `grammar_slot_type_setting` argument reference below.
     */
    @JvmName("vvsfcxfwfqouymoa")
    public suspend fun grammarSlotTypeSetting(argument: suspend V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.grammarSlotTypeSetting = mapped
    }

    internal fun build(): V2modelsSlotTypeExternalSourceSettingArgs =
        V2modelsSlotTypeExternalSourceSettingArgs(
            grammarSlotTypeSetting = grammarSlotTypeSetting,
        )
}
