@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyArn KMS key required to decrypt the contents of the grammar, if any.
 * @property s3BucketName Name of the Amazon S3 bucket that contains the grammar source.
 * @property s3ObjectKey Path to the grammar in the Amazon S3 bucket.
 */
public data class V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs(
    public val kmsKeyArn: Output<String>,
    public val s3BucketName: Output<String>,
    public val s3ObjectKey: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs.builder()
            .kmsKeyArn(kmsKeyArn.applyValue({ args0 -> args0 }))
            .s3BucketName(s3BucketName.applyValue({ args0 -> args0 }))
            .s3ObjectKey(s3ObjectKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgsBuilder internal constructor() {
    private var kmsKeyArn: Output<String>? = null

    private var s3BucketName: Output<String>? = null

    private var s3ObjectKey: Output<String>? = null

    /**
     * @param value KMS key required to decrypt the contents of the grammar, if any.
     */
    @JvmName("glxeygpmshvwwwjr")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Name of the Amazon S3 bucket that contains the grammar source.
     */
    @JvmName("bcnqpxjwwwnlducn")
    public suspend fun s3BucketName(`value`: Output<String>) {
        this.s3BucketName = value
    }

    /**
     * @param value Path to the grammar in the Amazon S3 bucket.
     */
    @JvmName("hbequsykirdslhcb")
    public suspend fun s3ObjectKey(`value`: Output<String>) {
        this.s3ObjectKey = value
    }

    /**
     * @param value KMS key required to decrypt the contents of the grammar, if any.
     */
    @JvmName("acodnkppkbsbdrie")
    public suspend fun kmsKeyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Name of the Amazon S3 bucket that contains the grammar source.
     */
    @JvmName("sxjjiyjtujxbswfl")
    public suspend fun s3BucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3BucketName = mapped
    }

    /**
     * @param value Path to the grammar in the Amazon S3 bucket.
     */
    @JvmName("kfgeacmxxgmqnrwq")
    public suspend fun s3ObjectKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3ObjectKey = mapped
    }

    internal fun build(): V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs =
        V2modelsSlotTypeExternalSourceSettingGrammarSlotTypeSettingSourceArgs(
            kmsKeyArn = kmsKeyArn ?: throw PulumiNullFieldException("kmsKeyArn"),
            s3BucketName = s3BucketName ?: throw PulumiNullFieldException("s3BucketName"),
            s3ObjectKey = s3ObjectKey ?: throw PulumiNullFieldException("s3ObjectKey"),
        )
}
