@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotTypeSlotTypeValuesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property slotTypeValues List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
 * @property synonyms Additional values related to the slot type entry. See `sample_value` argument reference below.
 */
public data class V2modelsSlotTypeSlotTypeValuesArgs(
    public val slotTypeValues: Output<List<V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs>>,
    public val synonyms: Output<List<V2modelsSlotTypeSlotTypeValuesSynonymArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotTypeSlotTypeValuesArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotTypeSlotTypeValuesArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotTypeSlotTypeValuesArgs.builder()
            .slotTypeValues(
                slotTypeValues.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .synonyms(
                synonyms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotTypeSlotTypeValuesArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeSlotTypeValuesArgsBuilder internal constructor() {
    private var slotTypeValues: Output<List<V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs>>? = null

    private var synonyms: Output<List<V2modelsSlotTypeSlotTypeValuesSynonymArgs>>? = null

    /**
     * @param value List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("lorwwortrdqcpyhw")
    public suspend fun slotTypeValues(`value`: Output<List<V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs>>) {
        this.slotTypeValues = value
    }

    @JvmName("pifyukhdcqfwuowx")
    public suspend fun slotTypeValues(vararg values: Output<V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs>) {
        this.slotTypeValues = Output.all(values.asList())
    }

    /**
     * @param values List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("csinrwiyrjgpnwen")
    public suspend fun slotTypeValues(values: List<Output<V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs>>) {
        this.slotTypeValues = Output.all(values)
    }

    /**
     * @param value Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("gsjyblhsxcljlnfn")
    public suspend fun synonyms(`value`: Output<List<V2modelsSlotTypeSlotTypeValuesSynonymArgs>>) {
        this.synonyms = value
    }

    @JvmName("vsbdlpkpkxcuicgk")
    public suspend fun synonyms(vararg values: Output<V2modelsSlotTypeSlotTypeValuesSynonymArgs>) {
        this.synonyms = Output.all(values.asList())
    }

    /**
     * @param values Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("svupxeouwsobsmdg")
    public suspend fun synonyms(values: List<Output<V2modelsSlotTypeSlotTypeValuesSynonymArgs>>) {
        this.synonyms = Output.all(values)
    }

    /**
     * @param value List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("ebxjxaqgfpjhdode")
    public suspend fun slotTypeValues(`value`: List<V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotTypeValues = mapped
    }

    /**
     * @param argument List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("kotlnqjilxtypmml")
    public suspend fun slotTypeValues(argument: List<suspend V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.slotTypeValues = mapped
    }

    /**
     * @param argument List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("hbvrybopvcsbhgnh")
    public suspend fun slotTypeValues(vararg argument: suspend V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.slotTypeValues = mapped
    }

    /**
     * @param argument List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("hqpiphjlljkwgpjo")
    public suspend fun slotTypeValues(argument: suspend V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.slotTypeValues = mapped
    }

    /**
     * @param values List of SlotTypeValue objects that defines the values that the slot type can take. Each value can have a list of synonyms, additional values that help train the machine learning model about the values that it resolves for a slot. See `slot_type_values` argument reference below.
     */
    @JvmName("fcqywlbfleberyup")
    public suspend fun slotTypeValues(vararg values: V2modelsSlotTypeSlotTypeValuesSlotTypeValueArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotTypeValues = mapped
    }

    /**
     * @param value Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("pjucrugukrsalsgm")
    public suspend fun synonyms(`value`: List<V2modelsSlotTypeSlotTypeValuesSynonymArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.synonyms = mapped
    }

    /**
     * @param argument Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("xipwypbthlxkmejv")
    public suspend fun synonyms(argument: List<suspend V2modelsSlotTypeSlotTypeValuesSynonymArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeSlotTypeValuesSynonymArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.synonyms = mapped
    }

    /**
     * @param argument Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("haphjrfmlywkdnpn")
    public suspend fun synonyms(vararg argument: suspend V2modelsSlotTypeSlotTypeValuesSynonymArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeSlotTypeValuesSynonymArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.synonyms = mapped
    }

    /**
     * @param argument Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("srjcfmydarfdlrmp")
    public suspend fun synonyms(argument: suspend V2modelsSlotTypeSlotTypeValuesSynonymArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2modelsSlotTypeSlotTypeValuesSynonymArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.synonyms = mapped
    }

    /**
     * @param values Additional values related to the slot type entry. See `sample_value` argument reference below.
     */
    @JvmName("mjhirrqudydlhnwa")
    public suspend fun synonyms(vararg values: V2modelsSlotTypeSlotTypeValuesSynonymArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.synonyms = mapped
    }

    internal fun build(): V2modelsSlotTypeSlotTypeValuesArgs = V2modelsSlotTypeSlotTypeValuesArgs(
        slotTypeValues = slotTypeValues ?: throw PulumiNullFieldException("slotTypeValues"),
        synonyms = synonyms,
    )
}
