@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property advancedRecognitionSettings Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
 * @property regexFilters Used to validate the value of the slot. See [`regex_filter` argument reference] below.
 * @property resolutionStrategy Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values: `ORIGINAL_VALUE` - Returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned. If you don't specify the valueSelectionStrategy , the default is `ORIGINAL_VALUE`. Valid values are `OriginalValue`, `TopResolution`, and `Concatenation`.
 */
public data class V2modelsSlotTypeValueSelectionSettingArgs(
    public val advancedRecognitionSettings: Output<List<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs>>? = null,
    public val regexFilters: Output<List<V2modelsSlotTypeValueSelectionSettingRegexFilterArgs>>? =
        null,
    public val resolutionStrategy: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingArgs.builder()
            .advancedRecognitionSettings(
                advancedRecognitionSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .regexFilters(
                regexFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resolutionStrategy(resolutionStrategy.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsSlotTypeValueSelectionSettingArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeValueSelectionSettingArgsBuilder internal constructor() {
    private var advancedRecognitionSettings:
        Output<List<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs>>? = null

    private var regexFilters: Output<List<V2modelsSlotTypeValueSelectionSettingRegexFilterArgs>>? =
        null

    private var resolutionStrategy: Output<String>? = null

    /**
     * @param value Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("srveypceoopjeagq")
    public suspend fun advancedRecognitionSettings(`value`: Output<List<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs>>) {
        this.advancedRecognitionSettings = value
    }

    @JvmName("yihgkldowsqcetgv")
    public suspend fun advancedRecognitionSettings(vararg values: Output<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs>) {
        this.advancedRecognitionSettings = Output.all(values.asList())
    }

    /**
     * @param values Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("xgsqpauojlpujdkn")
    public suspend fun advancedRecognitionSettings(values: List<Output<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs>>) {
        this.advancedRecognitionSettings = Output.all(values)
    }

    /**
     * @param value Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("ixfdbjefxxpopatd")
    public suspend fun regexFilters(`value`: Output<List<V2modelsSlotTypeValueSelectionSettingRegexFilterArgs>>) {
        this.regexFilters = value
    }

    @JvmName("jxnbarqdtvroamye")
    public suspend fun regexFilters(vararg values: Output<V2modelsSlotTypeValueSelectionSettingRegexFilterArgs>) {
        this.regexFilters = Output.all(values.asList())
    }

    /**
     * @param values Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("eraiwttjoroojbes")
    public suspend fun regexFilters(values: List<Output<V2modelsSlotTypeValueSelectionSettingRegexFilterArgs>>) {
        this.regexFilters = Output.all(values)
    }

    /**
     * @param value Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values: `ORIGINAL_VALUE` - Returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned. If you don't specify the valueSelectionStrategy , the default is `ORIGINAL_VALUE`. Valid values are `OriginalValue`, `TopResolution`, and `Concatenation`.
     */
    @JvmName("fvwigwwkpmrlbwhf")
    public suspend fun resolutionStrategy(`value`: Output<String>) {
        this.resolutionStrategy = value
    }

    /**
     * @param value Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("bdchrldimsncneuw")
    public suspend fun advancedRecognitionSettings(`value`: List<V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedRecognitionSettings = mapped
    }

    /**
     * @param argument Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("sgqirybxpsmfkifg")
    public suspend fun advancedRecognitionSettings(argument: List<suspend V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedRecognitionSettings = mapped
    }

    /**
     * @param argument Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("eccislosufvahcpb")
    public suspend fun advancedRecognitionSettings(vararg argument: suspend V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.advancedRecognitionSettings = mapped
    }

    /**
     * @param argument Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("pyxtvplmphugjowo")
    public suspend fun advancedRecognitionSettings(argument: suspend V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.advancedRecognitionSettings = mapped
    }

    /**
     * @param values Provides settings that enable advanced recognition settings for slot values. You can use this to enable using slot values as a custom vocabulary for recognizing user utterances. See [`advanced_recognition_setting` argument reference] below.
     */
    @JvmName("eftnvbywvqnkveef")
    public suspend fun advancedRecognitionSettings(vararg values: V2modelsSlotTypeValueSelectionSettingAdvancedRecognitionSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedRecognitionSettings = mapped
    }

    /**
     * @param value Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("cnwbvfmljlfixblp")
    public suspend fun regexFilters(`value`: List<V2modelsSlotTypeValueSelectionSettingRegexFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexFilters = mapped
    }

    /**
     * @param argument Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("pyppsjwsscjwxior")
    public suspend fun regexFilters(argument: List<suspend V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regexFilters = mapped
    }

    /**
     * @param argument Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("jsqrwfulhtybwihi")
    public suspend fun regexFilters(vararg argument: suspend V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regexFilters = mapped
    }

    /**
     * @param argument Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("ojlivdvfkuqbcrlp")
    public suspend fun regexFilters(argument: suspend V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.regexFilters = mapped
    }

    /**
     * @param values Used to validate the value of the slot. See [`regex_filter` argument reference] below.
     */
    @JvmName("cogytydpbdyxufak")
    public suspend fun regexFilters(vararg values: V2modelsSlotTypeValueSelectionSettingRegexFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexFilters = mapped
    }

    /**
     * @param value Determines the slot resolution strategy that Amazon Lex uses to return slot type values. The field can be set to one of the following values: `ORIGINAL_VALUE` - Returns the value entered by the user, if the user value is similar to the slot value. `TOP_RESOLUTION` If there is a resolution list for the slot, return the first value in the resolution list as the slot type value. If there is no resolution list, null is returned. If you don't specify the valueSelectionStrategy , the default is `ORIGINAL_VALUE`. Valid values are `OriginalValue`, `TopResolution`, and `Concatenation`.
     */
    @JvmName("jmhedrettutghurn")
    public suspend fun resolutionStrategy(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resolutionStrategy = mapped
    }

    internal fun build(): V2modelsSlotTypeValueSelectionSettingArgs =
        V2modelsSlotTypeValueSelectionSettingArgs(
            advancedRecognitionSettings = advancedRecognitionSettings,
            regexFilters = regexFilters,
            resolutionStrategy = resolutionStrategy ?: throw PulumiNullFieldException("resolutionStrategy"),
        )
}
