@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingRegexFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pattern Used to validate the value of a slot. Use a standard regular expression. Amazon Lex supports the following characters in the regular expression: A-Z, a-z, 0-9, Unicode characters ("\⁠u").
 * Represent Unicode characters with four digits, for example "\⁠u0041" or "\⁠u005A". The following regular expression operators are not supported: Infinite repeaters: *, +, or {x,} with no upper bound, wild card (.)
 */
public data class V2modelsSlotTypeValueSelectionSettingRegexFilterArgs(
    public val pattern: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingRegexFilterArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingRegexFilterArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotTypeValueSelectionSettingRegexFilterArgs.builder()
            .pattern(pattern.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2modelsSlotTypeValueSelectionSettingRegexFilterArgs].
 */
@PulumiTagMarker
public class V2modelsSlotTypeValueSelectionSettingRegexFilterArgsBuilder internal constructor() {
    private var pattern: Output<String>? = null

    /**
     * @param value Used to validate the value of a slot. Use a standard regular expression. Amazon Lex supports the following characters in the regular expression: A-Z, a-z, 0-9, Unicode characters ("\⁠u").
     * Represent Unicode characters with four digits, for example "\⁠u0041" or "\⁠u005A". The following regular expression operators are not supported: Infinite repeaters: *, +, or {x,} with no upper bound, wild card (.)
     */
    @JvmName("rvvguxbuihsgtysb")
    public suspend fun pattern(`value`: Output<String>) {
        this.pattern = value
    }

    /**
     * @param value Used to validate the value of a slot. Use a standard regular expression. Amazon Lex supports the following characters in the regular expression: A-Z, a-z, 0-9, Unicode characters ("\⁠u").
     * Represent Unicode characters with four digits, for example "\⁠u0041" or "\⁠u005A". The following regular expression operators are not supported: Infinite repeaters: *, +, or {x,} with no upper bound, wild card (.)
     */
    @JvmName("jgjqcdwristmxjpu")
    public suspend fun pattern(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pattern = mapped
    }

    internal fun build(): V2modelsSlotTypeValueSelectionSettingRegexFilterArgs =
        V2modelsSlotTypeValueSelectionSettingRegexFilterArgs(
            pattern = pattern ?: throw PulumiNullFieldException("pattern"),
        )
}
