@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property defaultValueSpecifications
 * @property promptSpecification
 * @property sampleUtterances
 * @property slotConstraint
 * @property slotResolutionSettings
 * @property waitAndContinueSpecifications
 */
public data class V2modelsSlotValueElicitationSettingArgs(
    public val defaultValueSpecifications: Output<List<V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs>>? = null,
    public val promptSpecification: Output<V2modelsSlotValueElicitationSettingPromptSpecificationArgs>,
    public val sampleUtterances: Output<List<V2modelsSlotValueElicitationSettingSampleUtteranceArgs>>? =
        null,
    public val slotConstraint: Output<String>,
    public val slotResolutionSettings: Output<List<V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs>>? = null,
    public val waitAndContinueSpecifications: Output<List<V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingArgs.builder()
            .defaultValueSpecifications(
                defaultValueSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .promptSpecification(
                promptSpecification.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sampleUtterances(
                sampleUtterances?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .slotConstraint(slotConstraint.applyValue({ args0 -> args0 }))
            .slotResolutionSettings(
                slotResolutionSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .waitAndContinueSpecifications(
                waitAndContinueSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotValueElicitationSettingArgs].
 */
@PulumiTagMarker
public class V2modelsSlotValueElicitationSettingArgsBuilder internal constructor() {
    private var defaultValueSpecifications:
        Output<List<V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs>>? = null

    private var promptSpecification:
        Output<V2modelsSlotValueElicitationSettingPromptSpecificationArgs>? = null

    private var sampleUtterances:
        Output<List<V2modelsSlotValueElicitationSettingSampleUtteranceArgs>>? = null

    private var slotConstraint: Output<String>? = null

    private var slotResolutionSettings:
        Output<List<V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs>>? = null

    private var waitAndContinueSpecifications:
        Output<List<V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs>>? = null

    /**
     * @param value
     */
    @JvmName("yggspgejxbljewaf")
    public suspend fun defaultValueSpecifications(`value`: Output<List<V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs>>) {
        this.defaultValueSpecifications = value
    }

    @JvmName("fidgxqsyufcismug")
    public suspend fun defaultValueSpecifications(vararg values: Output<V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs>) {
        this.defaultValueSpecifications = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dphjgfrbqftnkicd")
    public suspend fun defaultValueSpecifications(values: List<Output<V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs>>) {
        this.defaultValueSpecifications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("skaaqcegcodawjuw")
    public suspend fun promptSpecification(`value`: Output<V2modelsSlotValueElicitationSettingPromptSpecificationArgs>) {
        this.promptSpecification = value
    }

    /**
     * @param value
     */
    @JvmName("fgitflxdnegfbtec")
    public suspend fun sampleUtterances(`value`: Output<List<V2modelsSlotValueElicitationSettingSampleUtteranceArgs>>) {
        this.sampleUtterances = value
    }

    @JvmName("mdcvqmfmdbnjiyoa")
    public suspend fun sampleUtterances(vararg values: Output<V2modelsSlotValueElicitationSettingSampleUtteranceArgs>) {
        this.sampleUtterances = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ugipfleynjrflnyq")
    public suspend fun sampleUtterances(values: List<Output<V2modelsSlotValueElicitationSettingSampleUtteranceArgs>>) {
        this.sampleUtterances = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ivriwngohyfrfetq")
    public suspend fun slotConstraint(`value`: Output<String>) {
        this.slotConstraint = value
    }

    /**
     * @param value
     */
    @JvmName("ibdveleueohwlwcw")
    public suspend fun slotResolutionSettings(`value`: Output<List<V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs>>) {
        this.slotResolutionSettings = value
    }

    @JvmName("mqdramppouoleoav")
    public suspend fun slotResolutionSettings(vararg values: Output<V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs>) {
        this.slotResolutionSettings = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("thomoubppijdcood")
    public suspend fun slotResolutionSettings(values: List<Output<V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs>>) {
        this.slotResolutionSettings = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("iqembiyyemqptpsy")
    public suspend fun waitAndContinueSpecifications(`value`: Output<List<V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs>>) {
        this.waitAndContinueSpecifications = value
    }

    @JvmName("fnnjeprkmykstsxt")
    public suspend fun waitAndContinueSpecifications(vararg values: Output<V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs>) {
        this.waitAndContinueSpecifications = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bgkeropgapwrfmbk")
    public suspend fun waitAndContinueSpecifications(values: List<Output<V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs>>) {
        this.waitAndContinueSpecifications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("jmpgrugvfcxsrlph")
    public suspend fun defaultValueSpecifications(`value`: List<V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValueSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tybdtshmtpyqbvnt")
    public suspend fun defaultValueSpecifications(argument: List<suspend V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultValueSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("juftxrqwdmtbenfx")
    public suspend fun defaultValueSpecifications(vararg argument: suspend V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultValueSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("toofbbduqlplnvdv")
    public suspend fun defaultValueSpecifications(argument: suspend V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.defaultValueSpecifications = mapped
    }

    /**
     * @param values
     */
    @JvmName("whrqnxgavpytpkca")
    public suspend fun defaultValueSpecifications(vararg values: V2modelsSlotValueElicitationSettingDefaultValueSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultValueSpecifications = mapped
    }

    /**
     * @param value
     */
    @JvmName("hlgrtevxmjebjosx")
    public suspend fun promptSpecification(`value`: V2modelsSlotValueElicitationSettingPromptSpecificationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptSpecification = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sipalyafcnlxmdbd")
    public suspend fun promptSpecification(argument: suspend V2modelsSlotValueElicitationSettingPromptSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            V2modelsSlotValueElicitationSettingPromptSpecificationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.promptSpecification = mapped
    }

    /**
     * @param value
     */
    @JvmName("wkcyjaavceomeqbx")
    public suspend fun sampleUtterances(`value`: List<V2modelsSlotValueElicitationSettingSampleUtteranceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ddrfioftimpoiycc")
    public suspend fun sampleUtterances(argument: List<suspend V2modelsSlotValueElicitationSettingSampleUtteranceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingSampleUtteranceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sampleUtterances = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jwixguunimosmrnr")
    public suspend fun sampleUtterances(vararg argument: suspend V2modelsSlotValueElicitationSettingSampleUtteranceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingSampleUtteranceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sampleUtterances = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ioqnmgvlgprvxfen")
    public suspend fun sampleUtterances(argument: suspend V2modelsSlotValueElicitationSettingSampleUtteranceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotValueElicitationSettingSampleUtteranceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.sampleUtterances = mapped
    }

    /**
     * @param values
     */
    @JvmName("hxegodvflstvrdkw")
    public suspend fun sampleUtterances(vararg values: V2modelsSlotValueElicitationSettingSampleUtteranceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sampleUtterances = mapped
    }

    /**
     * @param value
     */
    @JvmName("voixkgnhiqwefgxt")
    public suspend fun slotConstraint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotConstraint = mapped
    }

    /**
     * @param value
     */
    @JvmName("uypdkeppwpokfxei")
    public suspend fun slotResolutionSettings(`value`: List<V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slotResolutionSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lfdhvkrqheohkcee")
    public suspend fun slotResolutionSettings(argument: List<suspend V2modelsSlotValueElicitationSettingSlotResolutionSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingSlotResolutionSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slotResolutionSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("oyojgtfcafslyycc")
    public suspend fun slotResolutionSettings(vararg argument: suspend V2modelsSlotValueElicitationSettingSlotResolutionSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingSlotResolutionSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.slotResolutionSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cogjhkkypqrjnscf")
    public suspend fun slotResolutionSettings(argument: suspend V2modelsSlotValueElicitationSettingSlotResolutionSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotValueElicitationSettingSlotResolutionSettingArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.slotResolutionSettings = mapped
    }

    /**
     * @param values
     */
    @JvmName("tawpqyosmokneewn")
    public suspend fun slotResolutionSettings(vararg values: V2modelsSlotValueElicitationSettingSlotResolutionSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slotResolutionSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("dsjvfpqaolfhtaxp")
    public suspend fun waitAndContinueSpecifications(`value`: List<V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitAndContinueSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("angcieyspbxkwhlr")
    public suspend fun waitAndContinueSpecifications(argument: List<suspend V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.waitAndContinueSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rdhknoipuveiiijf")
    public suspend fun waitAndContinueSpecifications(vararg argument: suspend V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.waitAndContinueSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wnirkpwugjmksyxn")
    public suspend fun waitAndContinueSpecifications(argument: suspend V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.waitAndContinueSpecifications = mapped
    }

    /**
     * @param values
     */
    @JvmName("ikwiwekuetqngfvc")
    public suspend fun waitAndContinueSpecifications(vararg values: V2modelsSlotValueElicitationSettingWaitAndContinueSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.waitAndContinueSpecifications = mapped
    }

    internal fun build(): V2modelsSlotValueElicitationSettingArgs =
        V2modelsSlotValueElicitationSettingArgs(
            defaultValueSpecifications = defaultValueSpecifications,
            promptSpecification = promptSpecification ?: throw PulumiNullFieldException("promptSpecification"),
            sampleUtterances = sampleUtterances,
            slotConstraint = slotConstraint ?: throw PulumiNullFieldException("slotConstraint"),
            slotResolutionSettings = slotResolutionSettings,
            waitAndContinueSpecifications = waitAndContinueSpecifications,
        )
}
