@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.inputs

import com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingPromptSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowInterrupt
 * @property maxRetries
 * @property messageGroups
 * @property messageSelectionStrategy
 * @property promptAttemptsSpecifications
 */
public data class V2modelsSlotValueElicitationSettingPromptSpecificationArgs(
    public val allowInterrupt: Output<Boolean>? = null,
    public val maxRetries: Output<Int>,
    public val messageGroups: Output<List<V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs>>? = null,
    public val messageSelectionStrategy: Output<String>? = null,
    public val promptAttemptsSpecifications: Output<List<V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingPromptSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingPromptSpecificationArgs =
        com.pulumi.aws.lex.inputs.V2modelsSlotValueElicitationSettingPromptSpecificationArgs.builder()
            .allowInterrupt(allowInterrupt?.applyValue({ args0 -> args0 }))
            .maxRetries(maxRetries.applyValue({ args0 -> args0 }))
            .messageGroups(
                messageGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .messageSelectionStrategy(messageSelectionStrategy?.applyValue({ args0 -> args0 }))
            .promptAttemptsSpecifications(
                promptAttemptsSpecifications?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [V2modelsSlotValueElicitationSettingPromptSpecificationArgs].
 */
@PulumiTagMarker
public class V2modelsSlotValueElicitationSettingPromptSpecificationArgsBuilder internal constructor() {
    private var allowInterrupt: Output<Boolean>? = null

    private var maxRetries: Output<Int>? = null

    private var messageGroups:
        Output<List<V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs>>? = null

    private var messageSelectionStrategy: Output<String>? = null

    private var promptAttemptsSpecifications:
        Output<List<V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>? =
        null

    /**
     * @param value
     */
    @JvmName("pnskwjwmtegofvid")
    public suspend fun allowInterrupt(`value`: Output<Boolean>) {
        this.allowInterrupt = value
    }

    /**
     * @param value
     */
    @JvmName("pslwbpbjcyvxnfqy")
    public suspend fun maxRetries(`value`: Output<Int>) {
        this.maxRetries = value
    }

    /**
     * @param value
     */
    @JvmName("qkkaispvqkarwpwc")
    public suspend fun messageGroups(`value`: Output<List<V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs>>) {
        this.messageGroups = value
    }

    @JvmName("arclhcldaqlcvyyb")
    public suspend fun messageGroups(vararg values: Output<V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs>) {
        this.messageGroups = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tgyploepfxafdusl")
    public suspend fun messageGroups(values: List<Output<V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs>>) {
        this.messageGroups = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("twgiassnuipuvvre")
    public suspend fun messageSelectionStrategy(`value`: Output<String>) {
        this.messageSelectionStrategy = value
    }

    /**
     * @param value
     */
    @JvmName("pbqaosssbnmkoihs")
    public suspend fun promptAttemptsSpecifications(`value`: Output<List<V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>) {
        this.promptAttemptsSpecifications = value
    }

    @JvmName("whckgilurliygpbj")
    public suspend fun promptAttemptsSpecifications(vararg values: Output<V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs>) {
        this.promptAttemptsSpecifications = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pdyjiqjygvsvwurl")
    public suspend fun promptAttemptsSpecifications(values: List<Output<V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs>>) {
        this.promptAttemptsSpecifications = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("icfatfwupenjxvqx")
    public suspend fun allowInterrupt(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowInterrupt = mapped
    }

    /**
     * @param value
     */
    @JvmName("bmaqkmlkcclhhwgs")
    public suspend fun maxRetries(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxRetries = mapped
    }

    /**
     * @param value
     */
    @JvmName("aobtcaggnmmvgown")
    public suspend fun messageGroups(`value`: List<V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iquhbjfqddiimvav")
    public suspend fun messageGroups(argument: List<suspend V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument
     */
    @JvmName("agrykpjjvhbrxrgj")
    public suspend fun messageGroups(vararg argument: suspend V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param argument
     */
    @JvmName("brolgsixlqfahfjk")
    public suspend fun messageGroups(argument: suspend V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.messageGroups = mapped
    }

    /**
     * @param values
     */
    @JvmName("ooodtsgsxlxkmlnw")
    public suspend fun messageGroups(vararg values: V2modelsSlotValueElicitationSettingPromptSpecificationMessageGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageGroups = mapped
    }

    /**
     * @param value
     */
    @JvmName("ewnbqofwcyinjvav")
    public suspend fun messageSelectionStrategy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageSelectionStrategy = mapped
    }

    /**
     * @param value
     */
    @JvmName("aqaeidjtsibyslih")
    public suspend fun promptAttemptsSpecifications(`value`: List<V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("piaxwvduatwjogfl")
    public suspend fun promptAttemptsSpecifications(argument: List<suspend V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ynufdjwcxjbbkyyf")
    public suspend fun promptAttemptsSpecifications(vararg argument: suspend V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dhajrwupwuxdkkku")
    public suspend fun promptAttemptsSpecifications(argument: suspend V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.promptAttemptsSpecifications = mapped
    }

    /**
     * @param values
     */
    @JvmName("oykrdjfdbyugxkts")
    public suspend fun promptAttemptsSpecifications(vararg values: V2modelsSlotValueElicitationSettingPromptSpecificationPromptAttemptsSpecificationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.promptAttemptsSpecifications = mapped
    }

    internal fun build(): V2modelsSlotValueElicitationSettingPromptSpecificationArgs =
        V2modelsSlotValueElicitationSettingPromptSpecificationArgs(
            allowInterrupt = allowInterrupt,
            maxRetries = maxRetries ?: throw PulumiNullFieldException("maxRetries"),
            messageGroups = messageGroups,
            messageSelectionStrategy = messageSelectionStrategy,
            promptAttemptsSpecifications = promptAttemptsSpecifications,
        )
}
