@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property messages
 * @property responseCard
 */
public data class BotAbortStatement(
    public val messages: List<BotAbortStatementMessage>,
    public val responseCard: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.BotAbortStatement): BotAbortStatement =
            BotAbortStatement(
                messages = javaType.messages().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.BotAbortStatementMessage.Companion.toKotlin(args0)
                    })
                }),
                responseCard = javaType.responseCard().map({ args0 -> args0 }).orElse(null),
            )
    }
}
