@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property content The text of the message.
 * @property contentType The content type of the message string.
 * @property groupNumber Identifies the message group that the message belongs to. When a group
 * is assigned to a message, Amazon Lex returns one message from each group in the response.
 */
public data class BotAbortStatementMessage(
    public val content: String,
    public val contentType: String,
    public val groupNumber: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.BotAbortStatementMessage): BotAbortStatementMessage = BotAbortStatementMessage(
            content = javaType.content(),
            contentType = javaType.contentType(),
            groupNumber = javaType.groupNumber().map({ args0 -> args0 }).orElse(null),
        )
    }
}
