@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property iamRoleArn The Amazon Resource Name (ARN) of the IAM role used to write your logs to CloudWatch Logs or an S3 bucket. Must be between 20 and 2048 characters in length.
 * @property logSettings The settings for your conversation logs. You can log text, audio, or both. Attributes are documented under log_settings.
 */
public data class BotAliasConversationLogs(
    public val iamRoleArn: String,
    public val logSettings: List<BotAliasConversationLogsLogSetting>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.BotAliasConversationLogs): BotAliasConversationLogs = BotAliasConversationLogs(
            iamRoleArn = javaType.iamRoleArn(),
            logSettings = javaType.logSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.BotAliasConversationLogsLogSetting.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
