@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property intentName The name of the intent. Must be less than or equal to 100 characters in length.
 * @property intentVersion The version of the intent. Must be less than or equal to 64 characters in length.
 */
public data class BotIntent(
    public val intentName: String,
    public val intentVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.BotIntent): BotIntent = BotIntent(
            intentName = javaType.intentName(),
            intentVersion = javaType.intentVersion(),
        )
    }
}
