@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBotAlias.
 * @property arn ARN of the bot alias.
 * @property botName Name of the bot.
 * @property botVersion Version of the bot that the alias points to.
 * @property checksum Checksum of the bot alias.
 * @property createdDate Date that the bot alias was created.
 * @property description Description of the alias.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedDate Date that the bot alias was updated. When you create a resource, the creation date and the last updated date are the same.
 * @property name Name of the alias. The name is not case sensitive.
 */
public data class GetBotAliasResult(
    public val arn: String,
    public val botName: String,
    public val botVersion: String,
    public val checksum: String,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val lastUpdatedDate: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.GetBotAliasResult): GetBotAliasResult =
            GetBotAliasResult(
                arn = javaType.arn(),
                botName = javaType.botName(),
                botVersion = javaType.botVersion(),
                checksum = javaType.checksum(),
                createdDate = javaType.createdDate(),
                description = javaType.description(),
                id = javaType.id(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                name = javaType.name(),
            )
    }
}
