@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getBot.
 * @property arn ARN of the bot.
 * @property checksum Checksum of the bot used to identify a specific revision of the bot's `$LATEST` version.
 * @property childDirected If this Amazon Lex Bot is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to COPPA.
 * @property createdDate Date that the bot was created.
 * @property description Description of the bot.
 * @property detectSentiment When set to true user utterances are sent to Amazon Comprehend for sentiment analysis.
 * @property enableModelImprovements Set to true if natural language understanding improvements are enabled.
 * @property failureReason If the `status` is `FAILED`, the reason why the bot failed to build.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property idleSessionTtlInSeconds The maximum time in seconds that Amazon Lex retains the data gathered in a conversation.
 * @property lastUpdatedDate Date that the bot was updated.
 * @property locale Target locale for the bot. Any intent used in the bot must be compatible with the locale of the bot.
 * @property name Name of the bot, case sensitive.
 * @property nluIntentConfidenceThreshold The threshold where Amazon Lex will insert the AMAZON.FallbackIntent, AMAZON.KendraSearchIntent, or both when returning alternative intents in a PostContent or PostText response. AMAZON.FallbackIntent and AMAZON.KendraSearchIntent are only inserted if they are configured for the bot.
 * @property status Status of the bot.
 * @property version Version of the bot. For a new bot, the version is always `$LATEST`.
 * @property voiceId Amazon Polly voice ID that the Amazon Lex Bot uses for voice interactions with the user.
 */
public data class GetBotResult(
    public val arn: String,
    public val checksum: String,
    public val childDirected: Boolean,
    public val createdDate: String,
    public val description: String,
    public val detectSentiment: Boolean,
    public val enableModelImprovements: Boolean,
    public val failureReason: String,
    public val id: String,
    public val idleSessionTtlInSeconds: Int,
    public val lastUpdatedDate: String,
    public val locale: String,
    public val name: String,
    public val nluIntentConfidenceThreshold: Double,
    public val status: String,
    public val version: String? = null,
    public val voiceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.GetBotResult): GetBotResult =
            GetBotResult(
                arn = javaType.arn(),
                checksum = javaType.checksum(),
                childDirected = javaType.childDirected(),
                createdDate = javaType.createdDate(),
                description = javaType.description(),
                detectSentiment = javaType.detectSentiment(),
                enableModelImprovements = javaType.enableModelImprovements(),
                failureReason = javaType.failureReason(),
                id = javaType.id(),
                idleSessionTtlInSeconds = javaType.idleSessionTtlInSeconds(),
                lastUpdatedDate = javaType.lastUpdatedDate(),
                locale = javaType.locale(),
                name = javaType.name(),
                nluIntentConfidenceThreshold = javaType.nluIntentConfidenceThreshold(),
                status = javaType.status(),
                version = javaType.version().map({ args0 -> args0 }).orElse(null),
                voiceId = javaType.voiceId(),
            )
    }
}
