@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property maxAttempts The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
 * @property messages
 * @property responseCard
 */
public data class IntentConfirmationPrompt(
    public val maxAttempts: Int,
    public val messages: List<IntentConfirmationPromptMessage>,
    public val responseCard: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentConfirmationPrompt): IntentConfirmationPrompt = IntentConfirmationPrompt(
            maxAttempts = javaType.maxAttempts(),
            messages = javaType.messages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.IntentConfirmationPromptMessage.Companion.toKotlin(args0)
                })
            }),
            responseCard = javaType.responseCard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
