@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property maxAttempts The number of times to prompt the user for information. Must be a number between 1 and 5 (inclusive).
 * @property messages A set of messages, each of which provides a message string and its type.
 * You can specify the message string in plain text or in Speech Synthesis Markup Language (SSML).
 * Attributes are documented under message. Must contain between 1 and 15 messages.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 */
public data class IntentFollowUpPromptPrompt(
    public val maxAttempts: Int,
    public val messages: List<IntentFollowUpPromptPromptMessage>,
    public val responseCard: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentFollowUpPromptPrompt): IntentFollowUpPromptPrompt = IntentFollowUpPromptPrompt(
            maxAttempts = javaType.maxAttempts(),
            messages = javaType.messages().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.IntentFollowUpPromptPromptMessage.Companion.toKotlin(args0)
                })
            }),
            responseCard = javaType.responseCard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
