@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property codeHook A description of the Lambda function that is run to fulfill the intent.
 * Required if type is CodeHook. Attributes are documented under code_hook.
 * @property type How the intent should be fulfilled, either by running a Lambda function or by
 * returning the slot data to the client application. Type can be either `ReturnIntent` or `CodeHook`, as documented [here](https://docs.aws.amazon.com/lex/latest/dg/API_FulfillmentActivity.html).
 */
public data class IntentFulfillmentActivity(
    public val codeHook: IntentFulfillmentActivityCodeHook? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentFulfillmentActivity): IntentFulfillmentActivity = IntentFulfillmentActivity(
            codeHook = javaType.codeHook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.IntentFulfillmentActivityCodeHook.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
