@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property messageVersion The version of the request-response that you want Amazon Lex to use
 * to invoke your Lambda function. For more information, see
 * [Using Lambda Functions](https://docs.aws.amazon.com/lex/latest/dg/using-lambda.html). Must be less than or equal to 5 characters in length.
 * @property uri The Amazon Resource Name (ARN) of the Lambda function.
 */
public data class IntentFulfillmentActivityCodeHook(
    public val messageVersion: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentFulfillmentActivityCodeHook): IntentFulfillmentActivityCodeHook = IntentFulfillmentActivityCodeHook(
            messageVersion = javaType.messageVersion(),
            uri = javaType.uri(),
        )
    }
}
