@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description A description of the bot. Must be less than or equal to 200 characters in length.
 * @property name The name of the intent slot that you want to create. The name is case sensitive. Must be less than or equal to 100 characters in length.
 * @property priority Directs Lex the order in which to elicit this slot value from the user.
 * For example, if the intent has two slots with priorities 1 and 2, AWS Lex first elicits a value for
 * the slot with priority 1. If multiple slots share the same priority, the order in which Lex elicits
 * values is arbitrary. Must be between 1 and 100.
 * @property responseCard The response card. Amazon Lex will substitute session attributes and
 * slot values into the response card. For more information, see
 * [Example: Using a Response Card](https://docs.aws.amazon.com/lex/latest/dg/ex-resp-card.html). Must be less than or equal to 50000 characters in length.
 * @property sampleUtterances If you know a specific pattern with which users might respond to
 * an Amazon Lex request for a slot value, you can provide those utterances to improve accuracy. This
 * is optional. In most cases, Amazon Lex is capable of understanding user utterances. Must have between 1 and 10 items in the list, and each item must be less than or equal to 200 characters in length.
 * @property slotConstraint Specifies whether the slot is required or optional.
 * @property slotType The type of the slot, either a custom slot type that you defined or one of
 * the built-in slot types. Must be less than or equal to 100 characters in length.
 * @property slotTypeVersion The version of the slot type. Must be less than or equal to 64 characters in length.
 * @property valueElicitationPrompt The prompt that Amazon Lex uses to elicit the slot value
 * from the user. Attributes are documented under prompt.
 */
public data class IntentSlot(
    public val description: String? = null,
    public val name: String,
    public val priority: Int? = null,
    public val responseCard: String? = null,
    public val sampleUtterances: List<String>? = null,
    public val slotConstraint: String,
    public val slotType: String,
    public val slotTypeVersion: String? = null,
    public val valueElicitationPrompt: IntentSlotValueElicitationPrompt? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.IntentSlot): IntentSlot = IntentSlot(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            responseCard = javaType.responseCard().map({ args0 -> args0 }).orElse(null),
            sampleUtterances = javaType.sampleUtterances().map({ args0 -> args0 }),
            slotConstraint = javaType.slotConstraint(),
            slotType = javaType.slotType(),
            slotTypeVersion = javaType.slotTypeVersion().map({ args0 -> args0 }).orElse(null),
            valueElicitationPrompt = javaType.valueElicitationPrompt().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.IntentSlotValueElicitationPrompt.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
