@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property synonyms Additional values related to the slot type value. Each item must be less than or equal to 140 characters in length.
 * @property value The value of the slot type. Must be less than or equal to 140 characters in length.
 */
public data class SlotTypeEnumerationValue(
    public val synonyms: List<String>? = null,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.SlotTypeEnumerationValue): SlotTypeEnumerationValue = SlotTypeEnumerationValue(
            synonyms = javaType.synonyms().map({ args0 -> args0 }),
            `value` = javaType.`value`(),
        )
    }
}
