@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property childDirected (Required) -  For each Amazon Lex bot created with the Amazon Lex Model Building Service, you must specify whether your use of Amazon Lex is related to a website, program, or other application that is directed or targeted, in whole or in part, to children under age 13 and subject to the Children's Online Privacy Protection Act (COPPA) by specifying true or false in the childDirected field.
 */
public data class V2modelsBotDataPrivacy(
    public val childDirected: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsBotDataPrivacy): V2modelsBotDataPrivacy = V2modelsBotDataPrivacy(
            childDirected = javaType.childDirected(),
        )
    }
}
