@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property engine Indicates the type of Amazon Polly voice that Amazon Lex should use for voice interaction with the user. Valid values are `standard` and `neural`. If not specified, the default is `standard`.
 * @property voiceId Identifier of the Amazon Polly voice to use.
 */
public data class V2modelsBotLocaleVoiceSettings(
    public val engine: String? = null,
    public val voiceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsBotLocaleVoiceSettings): V2modelsBotLocaleVoiceSettings = V2modelsBotLocaleVoiceSettings(
            engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
            voiceId = javaType.voiceId(),
        )
    }
}
