@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property active Whether an intent's closing response is used. When this field is false, the closing response isn't sent to the user. If the active field isn't specified, the default is true.
 * @property closingResponse Configuration block for response that Amazon Lex sends to the user when the intent is complete. See `closing_response`.
 * @property conditional Configuration block for list of conditional branches associated with the intent's closing response. These branches are executed when the `next_step` attribute is set to `EvalutateConditional`. See `conditional`.
 * @property nextStep Next step that the bot executes after playing the intent's closing response. See `next_step`.
 */
public data class V2modelsIntentClosingSetting(
    public val active: Boolean? = null,
    public val closingResponse: V2modelsIntentClosingSettingClosingResponse? = null,
    public val conditional: V2modelsIntentClosingSettingConditional? = null,
    public val nextStep: V2modelsIntentClosingSettingNextStep? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentClosingSetting): V2modelsIntentClosingSetting = V2modelsIntentClosingSetting(
            active = javaType.active().map({ args0 -> args0 }).orElse(null),
            closingResponse = javaType.closingResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingClosingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            conditional = javaType.conditional().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingConditional.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nextStep = javaType.nextStep().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingNextStep.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
