@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property customPayload Configuration block for a message in a custom format defined by the client application. See `custom_payload`.
 * @property imageResponseCard Configuration block for a message that defines a response card that the client application can show to the user. See `image_response_card`.
 * @property plainTextMessage Configuration block for a message in plain text format. See `plain_text_message`.
 * @property ssmlMessage Configuration block for a message in Speech Synthesis Markup Language (SSML). See `ssml_message`.
 */
public data class V2modelsIntentClosingSettingClosingResponseMessageGroupVariation(
    public val customPayload: V2modelsIntentClosingSettingClosingResponseMessageGroupVariationCustomPayload? = null,
    public val imageResponseCard: V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCard? = null,
    public val plainTextMessage: V2modelsIntentClosingSettingClosingResponseMessageGroupVariationPlainTextMessage? = null,
    public val ssmlMessage: V2modelsIntentClosingSettingClosingResponseMessageGroupVariationSsmlMessage? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariation): V2modelsIntentClosingSettingClosingResponseMessageGroupVariation =
            V2modelsIntentClosingSettingClosingResponseMessageGroupVariation(
                customPayload = javaType.customPayload().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationCustomPayload.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                imageResponseCard = javaType.imageResponseCard().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationImageResponseCard.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                plainTextMessage = javaType.plainTextMessage().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationPlainTextMessage.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ssmlMessage = javaType.ssmlMessage().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingClosingResponseMessageGroupVariationSsmlMessage.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
