@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property condition Configuration block for the expression to evaluate. If the condition is true, the branch's actions are taken. See `condition`.
 * @property name Name of the branch.
 * @property nextStep Configuration block for the next step in the conversation. See `next_step`.
 * @property response Configuration block for a list of message groups that Amazon Lex uses to respond to the user input. See `response`.
 */
public data class V2modelsIntentClosingSettingConditionalConditionalBranch(
    public val condition: V2modelsIntentClosingSettingConditionalConditionalBranchCondition,
    public val name: String,
    public val nextStep: V2modelsIntentClosingSettingConditionalConditionalBranchNextStep,
    public val response: V2modelsIntentClosingSettingConditionalConditionalBranchResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentClosingSettingConditionalConditionalBranch): V2modelsIntentClosingSettingConditionalConditionalBranch =
            V2modelsIntentClosingSettingConditionalConditionalBranch(
                condition = javaType.condition().let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingConditionalConditionalBranchCondition.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
                nextStep = javaType.nextStep().let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingConditionalConditionalBranchNextStep.Companion.toKotlin(args0)
                }),
                response = javaType.response().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentClosingSettingConditionalConditionalBranchResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
