@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property active Whether the intent's confirmation is sent to the user. When this field is false, confirmation and declination responses aren't sent. If the active field isn't specified, the default is true.
 * @property codeHook Configuration block for the intent's confirmation step. The dialog code hook is triggered based on these invocation settings when the confirmation next step or declination next step or failure next step is `invoke_dialog_code_hook`.  See `code_hook`.
 * @property confirmationConditional Configuration block for conditional branches to evaluate after the intent is closed. See `confirmation_conditional`.
 * @property confirmationNextStep Configuration block for the next step that the bot executes when the customer confirms the intent. See `confirmation_next_step`.
 * @property confirmationResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `confirmation_response`.
 * @property declinationConditional Configuration block for conditional branches to evaluate after the intent is declined. See `declination_conditional`.
 * @property declinationNextStep Configuration block for the next step that the bot executes when the customer declines the intent. See `declination_next_step`.
 * @property declinationResponse Configuration block for when the user answers "no" to the question defined in `prompt_specification`, Amazon Lex responds with this response to acknowledge that the intent was canceled. See `declination_response`.
 * @property elicitationCodeHook Configuration block for when the code hook is invoked during confirmation prompt retries. See `elicitation_code_hook`.
 * @property failureConditional Configuration block for conditional branches. Branches are evaluated in the order that they are entered in the list. The first branch with a condition that evaluates to true is executed. The last branch in the list is the default branch. The default branch should not have any condition expression. The default branch is executed if no other branch has a matching condition. See `failure_conditional`.
 * @property failureNextStep Configuration block for the next step to take in the conversation if the confirmation step fails. See `failure_next_step`.
 * @property failureResponse Configuration block for message groups that Amazon Lex uses to respond the user input. See `failure_response`.
 * @property promptSpecification Configuration block for prompting the user to confirm the intent. This question should have a yes or no answer. Amazon Lex uses this prompt to ensure that the user acknowledges that the intent is ready for fulfillment. See `prompt_specification`.
 */
public data class V2modelsIntentConfirmationSetting(
    public val active: Boolean? = null,
    public val codeHook: V2modelsIntentConfirmationSettingCodeHook? = null,
    public val confirmationConditional: V2modelsIntentConfirmationSettingConfirmationConditional? =
        null,
    public val confirmationNextStep: V2modelsIntentConfirmationSettingConfirmationNextStep? = null,
    public val confirmationResponse: V2modelsIntentConfirmationSettingConfirmationResponse? = null,
    public val declinationConditional: V2modelsIntentConfirmationSettingDeclinationConditional? =
        null,
    public val declinationNextStep: V2modelsIntentConfirmationSettingDeclinationNextStep? = null,
    public val declinationResponse: V2modelsIntentConfirmationSettingDeclinationResponse? = null,
    public val elicitationCodeHook: V2modelsIntentConfirmationSettingElicitationCodeHook? = null,
    public val failureConditional: V2modelsIntentConfirmationSettingFailureConditional? = null,
    public val failureNextStep: V2modelsIntentConfirmationSettingFailureNextStep? = null,
    public val failureResponse: V2modelsIntentConfirmationSettingFailureResponse? = null,
    public val promptSpecification: V2modelsIntentConfirmationSettingPromptSpecification,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSetting): V2modelsIntentConfirmationSetting = V2modelsIntentConfirmationSetting(
            active = javaType.active().map({ args0 -> args0 }).orElse(null),
            codeHook = javaType.codeHook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingCodeHook.Companion.toKotlin(args0)
                })
            }).orElse(null),
            confirmationConditional = javaType.confirmationConditional().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingConfirmationConditional.Companion.toKotlin(args0)
                })
            }).orElse(null),
            confirmationNextStep = javaType.confirmationNextStep().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingConfirmationNextStep.Companion.toKotlin(args0)
                })
            }).orElse(null),
            confirmationResponse = javaType.confirmationResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingConfirmationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            declinationConditional = javaType.declinationConditional().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingDeclinationConditional.Companion.toKotlin(args0)
                })
            }).orElse(null),
            declinationNextStep = javaType.declinationNextStep().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingDeclinationNextStep.Companion.toKotlin(args0)
                })
            }).orElse(null),
            declinationResponse = javaType.declinationResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingDeclinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            elicitationCodeHook = javaType.elicitationCodeHook().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingElicitationCodeHook.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failureConditional = javaType.failureConditional().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingFailureConditional.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failureNextStep = javaType.failureNextStep().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingFailureNextStep.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failureResponse = javaType.failureResponse().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingFailureResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            promptSpecification = javaType.promptSpecification().let({ args0 ->
                com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecification.Companion.toKotlin(args0)
            }),
        )
    }
}
