@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property active Whether a dialog code hook is used when the intent is activated.
 * @property enableCodeHookInvocation Whether a Lambda function should be invoked for the dialog.
 * @property invocationLabel Label that indicates the dialog step from which the dialog code hook is happening.
 * @property postCodeHookSpecification Configuration block that contains the responses and actions that Amazon Lex takes after the Lambda function is complete. See `post_code_hook_specification`.
 */
public data class V2modelsIntentConfirmationSettingCodeHook(
    public val active: Boolean,
    public val enableCodeHookInvocation: Boolean,
    public val invocationLabel: String? = null,
    public val postCodeHookSpecification: V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecification,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSettingCodeHook): V2modelsIntentConfirmationSettingCodeHook = V2modelsIntentConfirmationSettingCodeHook(
            active = javaType.active(),
            enableCodeHookInvocation = javaType.enableCodeHookInvocation(),
            invocationLabel = javaType.invocationLabel().map({ args0 -> args0 }).orElse(null),
            postCodeHookSpecification = javaType.postCodeHookSpecification().let({ args0 ->
                com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingCodeHookPostCodeHookSpecification.Companion.toKotlin(args0)
            }),
        )
    }
}
