@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property slotToElicit If the dialog action is `ElicitSlot`, defines the slot to elicit from the user.
 * @property suppressNextMessage Whether the next message for the intent is _not_ used.
 * @property type Action that the bot should execute. Valid values are `ElicitIntent`, `StartIntent`, `ElicitSlot`, `EvaluateConditional`, `InvokeDialogCodeHook`, `ConfirmIntent`, `FulfillIntent`, `CloseIntent`, `EndConversation`.
 */
public data class
V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepDialogAction(
    public val slotToElicit: String? = null,
    public val suppressNextMessage: Boolean? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepDialogAction): V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepDialogAction =
            V2modelsIntentConfirmationSettingFailureConditionalDefaultBranchNextStepDialogAction(
                slotToElicit = javaType.slotToElicit().map({ args0 -> args0 }).orElse(null),
                suppressNextMessage = javaType.suppressNextMessage().map({ args0 -> args0 }).orElse(null),
                type = javaType.type(),
            )
    }
}
