@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allowInterrupt Whether the user can interrupt a speech prompt from the bot.
 * @property maxRetries Maximum number of times the bot tries to elicit a response from the user using this prompt.
 * @property messageGroups Configuration block for messages that Amazon Lex can send to the user. Amazon Lex chooses the actual message to send at runtime. See `message_group`.
 * @property messageSelectionStrategy How a message is selected from a message group among retries. Valid values are `Random` and `Ordered`.
 * @property promptAttemptsSpecifications Configuration block for advanced settings on each attempt of the prompt. See `prompt_attempts_specification`.
 */
public data class V2modelsIntentConfirmationSettingPromptSpecification(
    public val allowInterrupt: Boolean? = null,
    public val maxRetries: Int,
    public val messageGroups: List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroup>? =
        null,
    public val messageSelectionStrategy: String? = null,
    public val promptAttemptsSpecifications: List<V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecification>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSettingPromptSpecification): V2modelsIntentConfirmationSettingPromptSpecification =
            V2modelsIntentConfirmationSettingPromptSpecification(
                allowInterrupt = javaType.allowInterrupt().map({ args0 -> args0 }).orElse(null),
                maxRetries = javaType.maxRetries(),
                messageGroups = javaType.messageGroups().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroup.Companion.toKotlin(args0)
                    })
                }),
                messageSelectionStrategy = javaType.messageSelectionStrategy().map({ args0 -> args0 }).orElse(null),
                promptAttemptsSpecifications = javaType.promptAttemptsSpecifications().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecificationPromptAttemptsSpecification.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
