@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.lex.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property buttons Configuration blocks for buttons that should be displayed on the response card. The arrangement of the buttons is determined by the platform that displays the button. See `button`.
 * @property imageUrl URL of an image to display on the response card. The image URL must be publicly available so that the platform displaying the response card has access to the image.
 * @property subtitle Subtitle to display on the response card. The format of the subtitle is determined by the platform displaying the response card.
 * @property title Title to display on the response card. The format of the title is determined by the platform displaying the response card.
 */
public data class
V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageImageResponseCard(
    public val buttons: List<V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageImageResponseCardButton>? =
        null,
    public val imageUrl: String? = null,
    public val subtitle: String? = null,
    public val title: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.lex.outputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageImageResponseCard): V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageImageResponseCard =
            V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageImageResponseCard(
                buttons = javaType.buttons().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.lex.kotlin.outputs.V2modelsIntentConfirmationSettingPromptSpecificationMessageGroupMessageImageResponseCardButton.Companion.toKotlin(args0)
                    })
                }),
                imageUrl = javaType.imageUrl().map({ args0 -> args0 }).orElse(null),
                subtitle = javaType.subtitle().map({ args0 -> args0 }).orElse(null),
                title = javaType.title(),
            )
    }
}
